// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================
package com.adobe.xmp.core;

/**
 * A visitor for the XMP nodes.
 * Please note that if you want to handle qualifiers,
 * you need to skip the qualifier facade which is not a node
 * and continue with the visitor on the qualifier tree.
 */
public interface XMPNodeVisitor 
{
	/**
	 * Handles visits of XMPSimple nodes
	 * @param simple the node to handle
	 */
	void visit( XMPSimple simple );
	
	/**
	 * Handles visits of XMPStruct nodes
	 * @param struct the node to handle
	 */
	void visit( XMPStruct struct );
	
	/**
	 * Handles visits of XMPArray nodes
	 * @param array the node to handle
	 */
	void visit( XMPArray array );
}
