package com.adobe.xmp.core.namespace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * Defines prefix/namespace contract for the standard namespaces.
 */
public class DefaultPrefixContract extends HashMap<String, String>
{
	private static final long serialVersionUID = 9169953737065019512L;

	/** 
	 * A prefix to namespace map that contains the default prefixes and 
	 * namespaces from the XMP specifications.
	 */
	private static HashMap<String, String> instance;
	
	/**
	 * Private constructor
	 */
	private DefaultPrefixContract() {}
	
	/**
	 * @return Returns an unmodifiable version of the prefix to namespace map.
	 */
	public static Map<String, String> getInstance()
	{
		if( instance == null )
		{
			initialize();
		}
		return Collections.unmodifiableMap( instance );
	}

	/**
	 * Initializes the map of default prefix to namespace-mappings.
	 * <em>Note:</em> Prefixes of the form ns1, ns2... are not allowed as defaults,
	 * they are used by the NamespaceResolver.
	 */
	private static void initialize()
	{
		instance = new HashMap<String, String>();

		// XML / RDF namespaces
		instance.put( XML.STANDARD_PREFIX, XML.URI );
		instance.put( RDF.STANDARD_PREFIX, RDF.URI );

		// Top-level schema namespaces
		instance.put( AdobePDF.STANDARD_PREFIX, AdobePDF.URI );
		instance.put( CameraRaw.STANDARD_PREFIX, CameraRaw.URI );
		instance.put( DublinCore.STANDARD_PREFIX, DublinCore.URI );		
		instance.put( EXIFSchemaForAdditionalEXIF.STANDARD_PREFIX, EXIFSchemaForAdditionalEXIF.URI );		
		instance.put( EXIFSchemaForEXIF.STANDARD_PREFIX, EXIFSchemaForEXIF.URI );
		instance.put( EXIFSchemaForTIFF.STANDARD_PREFIX, EXIFSchemaForTIFF.URI );
		instance.put( Photoshop.STANDARD_PREFIX, Photoshop.URI );
		instance.put( XMPBasic.STANDARD_PREFIX, XMPBasic.URI );
		instance.put( XMPBasicJobTicket.STANDARD_PREFIX, XMPBasicJobTicket.URI );
		instance.put( XMPDynamicMedia.STANDARD_PREFIX, XMPDynamicMedia.URI );
		instance.put( XMPMediaManagement.STANDARD_PREFIX, XMPMediaManagement.URI );
		instance.put( XMPPagedText.STANDARD_PREFIX, XMPPagedText.URI );
		instance.put( XMPRightsManagement.STANDARD_PREFIX, XMPRightsManagement.URI );
		
		// type namespaces
		instance.put( ResourceRef.STANDARD_PREFIX, ResourceRef.URI );
		instance.put( ResourceEvent.STANDARD_PREFIX, ResourceEvent.URI );
		
		// TODO add rest of standard namespace mappings
	}
}
