// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.core.parser;

import java.util.HashMap;
import java.util.Map;


/**
 * The context object for the RDFXMLParser.
 * It returns the prefix to namespace definitions found during parsing.
 * These can be re-used for serialization.
 */
@SuppressWarnings("serial")
public class RDFXMLParserContext extends HashMap<String, Object>
{
	/** the key for the prefix definition that are found during parsing */
	public static String PREFIX_DEFINITIONS = "prefixDefinitions";
	/** is populated with the XMP packet attributes, e.g. 'begin="" id="W5M0MpCehiHzreSzNTczkc9d"' */
	public static final String XPACKET_ATTRIBUTES = "xpacketAttributes";
	
	
	/**
	 * @return Returns the prefix definitions found in the parsed XMP packet or <code>null</code>.
	 */
	@SuppressWarnings("unchecked")
	public Map<String, String> getPrefixDefinitions()
	{
		Object result = super.get(PREFIX_DEFINITIONS);
		if (result instanceof Map )
		{
			return (Map<String, String>) result;
		}
		else
		{
			return null;
		}
	}
	
	
	/**
	 * @return Returns the attributes of the <?xpacket> processing instruction
	 * 		   if available or <code>null</code>.
	 */
	public String getXPacketAttributes()
	{
		Object result = super.get(XPACKET_ATTRIBUTES);
		if (result instanceof String )
		{
			return (String) result;
		}
		else
		{
			return null;
		}
	}
}
