// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model;


import com.adobe.xmp.schema.model.impl.SchemaModelFactoryImpl;

/**
 * @author Stefan Makswit
 */
public class SchemaModelFactory
{
	/** this is a global setting */
	public static boolean supportRuntimeDecorators = false;
	
	
	/**
	 * Creates a new XMP schema.
	 * 
	 * @param namespaceURI the namespace of the schema
	 * @return Returns an instance of SchemaDescription.
	 */
	public static SchemaDescription createSchema(String namespaceURI)
	{
		return SchemaModelFactoryImpl.createSchema(namespaceURI);
	}

	
	/**
	 * Creates a new XMP property.
	 * Convenience method for properties that inherit its' parent namespace. 
	 * 
	 * @param localName name of the property (within the namespace)
	 * @param type the property type, it can be simple, array or struct
	 * @return Returns an instance of PropertyDescription.
	 */
	public static PropertyDescription createProperty(String localName, PropertyType type)
	{
		return SchemaModelFactoryImpl.createProperty(null, localName, type);
	}

	
	/**
	 * Creates a new XMP property. Each property has a name and a type.
	 * Properties can be added to a schema or to a struct.
	 * 
	 * @param namespaceURI the namespace of the property
	 * @param localName name of the property (within the namespace)
	 * @param type the property type, it can be simple, array or struct
	 * @return Returns an instance of PropertyDescription.
	 */
	public static PropertyDescription createProperty(
			String namespaceURI, String localName, PropertyType type)
	{
		return SchemaModelFactoryImpl.createProperty(namespaceURI, localName, type);
	}
	
	
	/**
	 * Creates a type registry.
	 * It assigns names to XMP types and makes them re-usable.
	 * The "named" types are also needed to reference predefined types in our fragment libraries.
	 * The registry is not necessarily needed to create a schema.
	 *   
	 * @return Returns an instance of TypeRegistry.
	 */
	public static TypeRegistry createTypeRegistry()
	{
		return SchemaModelFactoryImpl.createTypeRegistry(supportRuntimeDecorators);
	}
}
