// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model;

import com.adobe.xmp.schema.model.rules.BooleanRule;
import com.adobe.xmp.schema.model.rules.ClosedChoice;
import com.adobe.xmp.schema.model.rules.DateRule;
import com.adobe.xmp.schema.model.rules.IntegerRule;
import com.adobe.xmp.schema.model.rules.LengthRule;
import com.adobe.xmp.schema.model.rules.LogicalRule;
import com.adobe.xmp.schema.model.rules.OpenChoice;
import com.adobe.xmp.schema.model.rules.PatternRule;
import com.adobe.xmp.schema.model.rules.RealRule;


/**
 * @author Stefan Makswit
 */
public interface SchemaVisitor
{
	/**
	 * Visit an {@link SchemaDescription}.
	 * 
	 * @param schema an SchemaDescription
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(SchemaDescription schema) throws XMPSchemaException;
	
	
	/**
	 * Visit an {@link PropertyDescription}.
	 * 
	 * @param property an {@link PropertyDescription}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(PropertyDescription property) throws XMPSchemaException;

	
	/**
	 * Visit an {@link SimpleType}
	 * 
	 * @param simpleType an SimpleType
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(SimpleType simpleType) throws XMPSchemaException;

	
	/**
	 * Visit an {@link ArrayType}.
	 * 
	 * @param arrayType an ArrayType
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(ArrayType arrayType) throws XMPSchemaException;


	/**
	 * Visit an {@link StructType}
	 * 
	 * @param structType an StructType
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(StructType structType) throws XMPSchemaException;

	
	/**
	 * Visit a rule
	 * 
	 * @param rule an {@link BooleanRule}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(BooleanRule rule) throws XMPSchemaException;

	
	/**
	 * Visit a rule
	 * 
	 * @param rule a {@link ClosedChoice} or an {@link OpenChoice}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(ClosedChoice rule) throws XMPSchemaException;

	
	/**
	 * Visit a rule
	 * 
	 * @param rule a {@link ClosedChoice} or an {@link OpenChoice}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(OpenChoice rule) throws XMPSchemaException;

	
	/**
	 * Visit a rule
	 * 
	 * @param rule an {@link DateRule}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(DateRule rule) throws XMPSchemaException;
	
	
	/**
	 * Visit a rule
	 * 
	 * @param rule an {@link IntegerRule}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(IntegerRule rule) throws XMPSchemaException;

	
	/**
	 * Visit a rule
	 * 
	 * @param rule an {@link LengthRule}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(LengthRule rule) throws XMPSchemaException;

	
	/**
	 * Visit a rule
	 * 
	 * @param rule an {@link LogicalRule}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(LogicalRule rule) throws XMPSchemaException;

	
	/**
	 * Visit a rule
	 * 
	 * @param rule an {@link PatternRule}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(PatternRule rule) throws XMPSchemaException;
	

	/**
	 * Visit a rule
	 * 
	 * @param rule an {@link RealRule}
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void visit(RealRule rule) throws XMPSchemaException;
}
