/**************************************************************************
 *                                                                        *
 * ADOBE CONFIDENTIAL                                                     *
 * ___________________                                                    *
 *                                                                        *
 *  Copyright 2011 Adobe Systems Incorporated                             *
 *  All Rights Reserved.                                                  *
 *                                                                        *
 * NOTICE:  All information contained herein is, and remains              *
 * the property of Adobe Systems Incorporated and its suppliers,          *
 * if any.  The intellectual and technical concepts contained             *
 * herein are proprietary to Adobe Systems Incorporated and its           *
 * suppliers and are protected by trade secret or copyright law.          *
 * Dissemination of this information or reproduction of this material     *
 * is strictly forbidden unless prior written permission is obtained      *
 * from Adobe Systems Incorporated.                                       *
 **************************************************************************/
package com.adobe.xmp.schema.service;


/**
 * Exception that indicates errors while retrieving schema or type information.
 * 
 * @author Stefan Makswit
 */
public class SchemaServiceException extends Exception
{
	private static final long serialVersionUID = 8364384923927034402L;

	
	/**
	 * Constructs a new SchemaServiceException.
	 *
	 * @param message the error message
	 */
	public SchemaServiceException(String message)
	{
		super(message);
	}


	/**
	 * Constructs a new SchemaServiceException.
	 *
	 * @param message the error message
	 * @param e the embedded exception
	 */
	public SchemaServiceException(String message, Exception e)
	{
		super(message, e);
	}
}
