/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst;

import java.util.Collection;

import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;

import com.day.cq.wcm.webservicesupport.Configuration;

/**
 * Is a wrapper around
 * {@link com.day.cq.analytics.sitecatalyst.SitecatalystHttpClient} for SAINT
 * API related calls.
 * 
 * @deprecated not in use any longer
 */
@Deprecated
public interface SAINTService {

    /**
     * Checks for the status of a SAINT job.
     * 
     * @param configuration Web service support configuration
     * @param jobId SAINT job identifier
     * @return A JSONObject containing the job information. The object is of the
     *         following structure:
     *         <p>
     *         <code>
     *         {<br>
     *         &nbsp; Id: (int),<br>
     *         &nbsp; Type: (string: "Job"|"File"),<br>
     *         &nbsp; Viewable_pages: (int),<br>
     *         &nbsp; Status: (string: "Waiting For User Data"|"In Progress"|"Completed"|"Completed--With Errors")<br>
     *         }<br>
     *         </code>
     *         </p>
     * @throws SitecatalystException might be thrown
     */
    JSONObject getJobStatus(Configuration configuration, int jobId) throws SitecatalystException;

    /**
     * Returns a list of compatible metrics for specific
     * <code>reportSuites</code>.
     * 
     * @param configuration Web service support configuration
     * @param reportSuites Array of report suite identifiers
     * @return A JSONArray of JSONObjects containing the classified metrics. The
     *         objects are of the following structure:
     *         <p>
     *         <code>
     *         {<br>
     *         &nbsp; relation_id: (int),<br>
     *         &nbsp; relation_name: (string),<br>
     *         &nbsp; report_suite: (string),<br>
     *         &nbsp; site_title: (string),<br>
     *         &nbsp; compatability_hash: (string)<br>
     *         }
     *         </code>
     *         </p>
     * @throws SitecatalystException might be thrown
     */
    JSONArray getCompatabilityMetrics(Configuration configuration, String[] reportSuites) throws SitecatalystException;
    
    /**
     * Returns a list of filters for the specified <code>reportSuites</code>.
     * 
     * @param configuration
     *            Web service support configuration
     * @param relationId  the relation ID
     * @param reportSuites
     *            Array of report suite identifiers
     * @return A JSONArray of JSONObjects containing the information about valid
     *         data filters for an export job. The objects are of the following 
     *         structure:
     *         <p>
     *         <code>
     *         {<br>
     *         &nbsp; date_received_dates: [{date: (string)},...]<br>
     *         &nbsp; columns: [{num: (int), name: (string)},...]<br>
     *         }
     *         </code>
     *         </p>
     * @throws SitecatalystException might be thrown
     */
    JSONArray getFilters(Configuration configuration, int relationId, String[] reportSuites) throws SitecatalystException;
    
    /**
     * Creates a SAINT export job. Before calling this API, use
     * {@link #getFilters(Configuration, int, String[])} to obtain valid column numbers
     * and names, and filter dates. After creating an export job, use
     * {@link #getJobStatus(Configuration, int)} to determine when the export
     * data is ready for download. Note: Export data files can be very large.
     * Use {@link #exportGetFileSegment(Configuration, int, int)} to download the file in
     * pieces (segments).
     * 
     * @param configuration Web service support configuration
     * @param filterOption The filter option to use for the SAINT export.
     *            Supported values include:
     *            <ul>
     *            <li>0: Return all Campaigns (No filter)
     *            <li>1: (Default) Return active campaigns
     *            <li>2: Return campaigns with the specified begin and end date.
     *            </ul>
     * @param rowStartDate The start date for including rows in the export.
     *            Include this parameter when <code>filterOption</code> = 1.
     *            Specify the date using the following format:
     *            <code>Mmm YYYY</code>, where:
     *            <ul>
     *            <li>Mmm: A three-character month code. For example,
     *            January=Jan, February=Feb, and so on.
     *            <li>YYYY: The 4-digit year.
     *            </ul>
     *            For example, September, 2008 is Sep 2008.
     * @param rowEndDate The end date for including rows in the export. Include
     *            this parameter when <code>filterOption</code> = 1. Use the
     *            same date range format described for the
     *            <code>rowStartDate</code> parameter.
     * @param beginRange The campaign start date. Include this parameter when
     *            <code>filterOption = 2</code>. Specify the date range using
     *            the following format:
     *            <code>&lt;start_date&gt;-&lt;end_date&gt;</code>. Provide the
     *            date in the following format: <code>YYYMMDD</code>, where:
     *            <ul>
     *            <li>YYY + 1900 equals the year (For example, 2008 is 108).
     *            <li>MM equals the month number minus 1 (January = 00, February
     *            = 01, and so on).
     *            <li>DD equals the 2 digit day. For example, May 22, 2008 is
     *            1080422.
     *            </ul>
     * @param endRange The campaign end date. Include this parameter when
     *            <code>filterOption</code> = 2. Use the same date range format
     *            described for the <code>beginRange</code> parameter.
     * @param email E-Mail address to receive job notifications.
     * @param encoding The language encoding to use with the export file. For
     *            example, UTF-8.
     * @param relationId Relation identifier of classification the import should
     *            be done for.
     * @param reportSuites (Optional) The list of report suites on which SAINT
     *            exports data.
     * @param emptyColumnName (Optional) The column name that SAINT checks for
     *            empty data cells. If the cell is not empty, SAINT excludes it
     *            from the export.
     * @param matchColumnName (Optional) The column name that SAINT checks for
     *            cell values that match the value specified in the
     *            <code>matchColumnValue</code> parameter. If the cell
     *            value matches the value, SAINT excludes it from the export.
     * @param matchColumnValue (Optional) The value that SAINT uses to exclude a
     *            data row from the export. Include this parameter when using
     *            <code>matchColumnName</code>.
     * @param selectAllRows (Optional) Specifies whether to include all data rows in
     *            the export (up to the 50,000 row limit).
     *            (Default) Include all rows in the export.
     * @param selectNumRows (Optional) Limits the number of data rows in the export
     *            file to the specified value. The default limit is 50,000.
     *            Include this parameter when <code>selectAllRows</code> is <code>true</code>.
     * @return Export job identifier
     * @throws SitecatalystException might be thrown
     */
    int createExportJob(Configuration configuration, int filterOption, String rowStartDate, String rowEndDate, String beginRange,
            String endRange, String email, String encoding, int relationId, String[] reportSuites, String emptyColumnName, 
            String matchColumnName, String matchColumnValue, boolean selectAllRows, int selectNumRows) throws SitecatalystException;

    /**
     * Retrieves a page of data, known as a file segment, from a completed Saint
     * job.
     * 
     * @param configuration Web service support configuration
     * @param fileId The ID of the export file you want to view. You can get
     *            this value from {{@link #getJobStatus(Configuration, int)}
     * @param segmentId The number of the data page you want to view from the
     *            SAINT export job. The viewable_pages value in {
     *            {@link #getJobStatus(Configuration, int)} indicates the number
     *            of data pages in the job. Valid values for segment_id are
     *            between 1 and the value of viewable_pages.
     * @return A JSONArray of JSONObjects containing the information and data
     *         for the specified SAINT data segment. The objects are of the
     *         following structure:
     *         <p>
     *         <code>
     *         {<br>
     *         &nbsp; warnings: [(string),...]<br>
     *         &nbsp; header: [(string),...]<br>
     *         &nbsp; data: [[(string)],...]<br>
     *         }
     *         </code>
     *         </p>
     * @throws SitecatalystException might be thrown
     */
    JSONArray exportGetFileSegment(Configuration configuration, int fileId, int segmentId) throws SitecatalystException;

    /**
     * Creates a SAINT Import Job. To successfully submit a SAINT Import, call
     * {@link SAINTService#createImportJob(Configuration, String, String, String[], int, boolean, boolean, boolean, String...)}
     * to specify the parameters for the Import job and the header columns to be
     * classified. After submitting the job, you can iteratively populate row
     * data by calling
     * {@link SAINTService#populateImportJob(Configuration, int, int, Collection)}. After
     * sending all data, call {@link SAINTService#commitImportJob(Configuration, int)} to
     * finalize the Import job and submit it to the SAINT processing queue.
     * 
     * @param configuration Web service support configuration
     * @param description Description of the import job.
     * @param email E-Mail address to receive job notifications.
     * @param header Array of column values for classification.
     * @param relationId Relation identifier of classification the import should
     *            be done for.
     * @param checkDivisions Specifies whether to check report suites for
     *            compatible divisions.
     * @param exportResults Specifies whether to automatically perform an export
     *            when the import job finishes processing.
     * @param overwrite Specifies whether to overwrite data when conflicts
     *            occur.
     * @param reportSuites (Optional) List of report suites to receive the
     *            import job.
     * @return Import job identifier
     * @throws SitecatalystException might be thrown
     */
    @Deprecated
    int createImportJob(Configuration configuration, String description, String email, String[] header, int relationId,
            boolean checkDivisions, boolean exportResults, boolean overwrite, String... reportSuites)
            throws SitecatalystException;
    
    /**
     * Creates a SAINT Import Job. To successfully submit a SAINT Import, call
     * {@link SAINTService#createImportJob(Configuration, String, String, String[], int, boolean, boolean, boolean, String...)}
     * to specify the parameters for the Import job and the header columns to be
     * classified. After submitting the job, you can iteratively populate row
     * data by calling
     * {@link SAINTService#populateImportJob(Configuration, int, int, Collection)}. After
     * sending all data, call {@link SAINTService#commitImportJob(Configuration, int)} to
     * finalize the Import job and submit it to the SAINT processing queue.
     * 
     * @param configuration Web service support configuration
     * @param description Description of the import job.
     * @param email E-Mail address to receive job notifications.
     * @param header Array of column values for classification.
     * @param classificationView The report for which you want to perform a
     *            SAINT import
     * @param checkDivisions Specifies whether to check report suites for
     *            compatible divisions.
     * @param exportResults Specifies whether to automatically perform an export
     *            when the import job finishes processing.
     * @param overwrite Specifies whether to overwrite data when conflicts
     *            occur.
     * @param reportSuites (Optional) List of report suites to receive the
     *            import job.
     * @return Import job identifier
     * @throws SitecatalystException might be thrown
     */
    public int createImportJob(Configuration configuration, String description, String email, String[] header,
            String classificationView, boolean checkDivisions, boolean exportResults, boolean overwrite,
            String... reportSuites) throws SitecatalystException;
    
    /**
     * Appends row data to a previously created import job. Data can be
     * separated into pages, but the pages must be sent sequentially (either
     * ascending or descending) to avoid errors when SAINT processes the job.
     * <blockquote>Note: Individual SAINT job pages cannot exceed 25,000
     * rows.</blockquote>
     * 
     * @param configuration Web service support configuration
     * @param jobId SAINT job identifier to append row data
     * @param page Page number that identifies the sequential position in the
     *            SAINT import job. For example, if you submit a spreadsheet
     *            with 1000 values, divided into 4 pages, page 1 includes values
     *            1 - 250, page 2 includes values 251 - 500, and so on.
     * @param rows Collection of row data that matches the column heading
     * @return <code>true</code> if population was successful,
     *         <code>false</code> otherwise.
     * @throws SitecatalystException might be thrown
     */
    boolean populateImportJob(Configuration configuration, int jobId, int page, Collection<String[]> rows)
            throws SitecatalystException;

    /**
     * Commits the SAINT import for processing.
     * 
     * @param configuration Web service support configuration
     * @param jobId SAINT import job identifier
     * @return <code>true</code> if job has been processed successfully,
     *         <code>false</code> otherwise.
     * @throws SitecatalystException might be thrown
     */
    boolean commitImportJob(Configuration configuration, int jobId) throws SitecatalystException;

}
