/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst.common;

import com.day.cq.analytics.sitecatalyst.impl.util.AnalyticsAPICallsUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

import com.day.cq.analytics.sitecatalyst.SitecatalystException;


/**
 * Provides common methods used for implementing the various SiteCatalyst APIs.
 */
public abstract class AbstractSiteCatalystService {

    /**
     * Returns a {@link org.apache.sling.commons.json.JSONObject} constructed
     * from the <code>result</code> string. If the created object contains a key
     * "error" a {@link com.day.cq.analytics.sitecatalyst.SitecatalystException}
     * with the key's value is thrown.
     * 
     * @param result Result String
     * @return {@link org.apache.sling.commons.json.JSONObject} constructed
     * from the <code>result</code> string
     * @throws SitecatalystException if the result contains an
     *             <code>error</code> key or a JSONException occurred
     */
    protected JSONObject toJSONObject(String result) throws SitecatalystException {
        try {
            JSONObject o = new JSONObject(result);
            if (o.has("error")) {
                throw new SitecatalystException(o.getString("error"));
            }
            return o;
        } catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    /**
     * Returns a {@link org.apache.sling.commons.json.JSONArray} constructed
     * from the <code>result</code> string.
     * 
     * @param result Result String
     * @return {@link org.apache.sling.commons.json.JSONArray} constructed
     * from the <code>result</code> string
     * @throws SitecatalystException if result is a JSON object and contains an
     *             error description
     */
    protected JSONArray toJSONArray(String result) throws SitecatalystException {
        try {
            String error = getError(result);
            if (error != null) {
                throw new SitecatalystException(error);
            }
            return new JSONArray(result);
        } catch (JSONException e) {
            throw new SitecatalystException(e.getMessage(), e);
        }
    }

    /**
     * Gets the error key of a result if it exists, otherwise <code>null</code>
     * is returned.
     * 
     * @param result result string
     * @return error key of a result if it exists, otherwise <code>null</code>
     * @throws JSONException might be thrown in case result JSONObject can't be read from {@code result} String
     */
    protected String getError(String result) throws JSONException {
        return AnalyticsAPICallsUtils.getErrorMessageFromResponse(result);
    }

}