/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst.datainsertion;

import com.day.cq.analytics.sitecatalyst.SitecatalystException;

/**
 * The <code>DataInsertionClient</code> is executing
 * <code>DataInsertionRequest</code>'s to a provided end point URI.
 */
public interface DataInsertionClient {

    /**
     * Executes the <code>DataInsertionRequest</code> through a POST request.
     * 
     * @param request {@link DataInsertionRequest} to execute
     * @param url URL to DataInsertion service
     * @return DataInsertionResponse
     * @throws SitecatalystException if an error occurs during the execution
     */
    DataInsertionResponse execute(DataInsertionRequest request, String url) throws SitecatalystException;

    /**
     * Executes a GET request with the provided <code>URI</code>
     * which should contain query string parameters.
     * 
     * @param url URL to execute
     * @throws SitecatalystException if an error occurs during the execution
     */
    void execute(String url) throws SitecatalystException;

}