/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst.rsmerger;

import java.util.Map;
import java.util.TreeMap;

import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

@Deprecated
public abstract class AbstractMerger implements Merger {

    protected JSONObject jsonObj;
    protected Map<Integer, MergedVariable> varMap;

    public AbstractMerger(JSONArray variables) throws JSONException {
        if (variables.length() > 0)
            this.jsonObj = variables.getJSONObject(0);
        else
            this.jsonObj = new JSONObject();

        this.varMap = new TreeMap<Integer, MergedVariable>();
    }

    protected void intertwine(ReportSuiteVariable rsvar) {
        int index = 0;
        for (Variable var : rsvar.getVariables()) {
            MergedVariable mVar = varMap.get(index);
            if (mVar == null) {
                mVar = new MergedVariable(var.getJSONObject());
                varMap.put(index, mVar);
            }
            mVar.put(var.getName(), rsvar.getRsid());
            index++;
        }
    }

    protected JSONArray getVariables() throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<Integer, MergedVariable> entry : varMap.entrySet()) {
            JSONObject jsonVar = mergeVariable(entry.getKey(), entry.getValue());
            jsonArray.put(jsonVar);
        }
        return jsonArray;
    }

}
