/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class AuthenticationHelper {
    
    /**
     * Generates Web Service Shared Secret.
     * 
     * @param password password
     * @return shared secret
     * @deprecated Use
     *             {@link com.day.cq.analytics.sitecatalyst.SitecatalystWebservice#getLoginKey(String, String, String)}
     *             instead
     */
    @Deprecated
    public static String generateSharedSecret(String password) {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }
    
    /**
     * Generates ApplicationKey for Sitecatalyst WebService.
     * 
     * @param nonceValue nonceValue
     * @param key key
     * @return ApplicationKey
     * @throws Exception {@link Exception}
     * @deprecated
     */
    @Deprecated
    public static synchronized String generateApplicationKey(byte[] nonceValue, String key) throws Exception {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }
    
    /**
     * SHA-1(nonce + created + password)
     * @param nonce nonce
     * @param created created
     * @param password password
     * @return Base64Digest
     */
    public static synchronized String getBase64Digest(byte[] nonce, byte[] created, byte[] password) {
      try {
        MessageDigest messageDigester = MessageDigest.getInstance("SHA-1");
        messageDigester.reset();
        messageDigester.update(nonce);
        messageDigester.update(created);
        messageDigester.update(password);
        return base64Encode(messageDigester.digest());
      } catch (NoSuchAlgorithmException e) {
        throw new RuntimeException(e);
      }
    }

    /**
     * SHA-1(nonce + API_PASS)
     * @param nonce nonce
     * @param apiPass apiPass
     * @return base64DigestKey
     */
    public static synchronized String getBase64DigestKey(byte[] nonce, byte[] apiPass) {
        try {
            MessageDigest messageDigester = MessageDigest.getInstance("SHA-1");
            messageDigester.reset();
            messageDigester.update(nonce);
            messageDigester.update(apiPass);
            return base64Encode(messageDigester.digest());
        } catch(NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /**
     * Encodes bytes to a BASE64 String.
     * 
     * @param bytes bytes
     * @return  base64 encoded String of the bytes
     */
    public static String base64Encode(byte[] bytes) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(bytes, false));
    } 

}
