/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Performance report for a single campaign containing multiple <tt>Sample</tt>s.
 * 
 * @see <a href="https://developer.omniture.com/en_US/documentation/test-target/r-performance-report"> Adobe Target
 *      performance report API</a>
 */
public class Report {

    private final String campaignId;
    private final Date start;
    private final Date end;
    private final Resolution resolution;
    private final ReportType type;
    private final List<Sample> samples = new ArrayList<Sample>();

    public Report(String campaignId, Date start, Date end, Resolution resolution, ReportType type) {
        this.campaignId = campaignId;
        this.start = start;
        this.end = end;
        this.resolution = resolution;
        this.type = type;
    }

    public void addSample(Sample sample) {
        samples.add(sample);
    }

    public String getCampaignId() {
        return campaignId;
    }

    public Date getStart() {
        return start;
    }

    public Date getEnd() {
        return end;
    }

    public Resolution getResolution() {
        return resolution;
    }

    public ReportType getType() {
        return type;
    }

    public List<Sample> getSamples() {
        return samples;
    }
}