/*******************************************************************************
 * ADOBE CONFIDENTIAL
 *  __________________
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget;


import com.day.cq.analytics.testandtarget.impl.OfferBase;

/**
 * A request object used to create an offer in Adobe Target
 */
public class SaveOfferRequest extends OfferBase {

    /**
     * Constructs a {@link SaveOfferRequest} using the parameters required to update an offer
     * @param id the offer id, as assigned by Adobe Target. This cannot be 0
     * @param name the offer name
     * @param content the content of the offer
     */
    public SaveOfferRequest(long id, String name, String content) {
       super(id, name, content);
    }

    /**
     * Constructs an object of this type using the minimal required to create an offer.
     * @param name the offer name
     * @param content the content of the offer
     */
    public SaveOfferRequest(String name, String content) {
        super(0,name, content);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getContentPath() {
        return super.getContentPath();
    }

    @Override
    public String getContent() {
        return super.getContent();
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + ": [" + this.getName() +"; " + this.getContent() + "]";
    }
}
