/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.Date;
import java.util.Map;

/**
 * A segment, as it is represented in Adobe Target
 * 
 * <p>
 * The properties of a segment are exactly those returned by the Adobe Target API, with no modification.
 * </p>
 * 
 */
public class Segment {

    private long id;
    private String path;
    private String name;
    private String description;
    private String segmentRule;
    private Date createdAt;
    private String createdBy;
    private Date modifiedAt;
    private String modifiedBy;
    private String origin;
    private boolean hidden;
    private String type;
    private Map<String, String> marketingCloudMetadata;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSegmentRule() {
        return segmentRule;
    }

    public void setSegmentRule(String segmentRule) {
        this.segmentRule = segmentRule;
    }

    public Date getCreated() {
        return createdAt;
    }

    public void setCreated(Date created) {
        this.createdAt = created;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getModified() {
        return modifiedAt;
    }

    public void setModified(Date modified) {
        this.modifiedAt = modified;
    }

    public String getModifiedBy() {
        return modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public boolean getHidden() { return hidden; }

    public void setHidden(boolean hidden) { this.hidden = hidden; }

    /**
     * Segment type [reusable|anonymous]
     * Present starting with TnT segments API v7
     * @since AEM 6.2
     *
     * @return segment type {@code String}
     */
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    /**
     * Segment metadata information
     * Contains following information keys: sourceProductName, editURL, remoteModifiedBy
     * Present starting with TnT segments API v7
     * @since AEM 6.2
     *
     * @return metadata information {@code Map}
     */
    public Map<String, String> getMarketingCloudMetadata() {
        return marketingCloudMetadata;
    }

    public void setMarketingCloudMetadata(Map<String, String> metadata) {
        this.marketingCloudMetadata = metadata;
    }

    /**
     * Returns this segments's source, i.e. the solution that contributed it to Target (could be AAM, Bullseye or
     * Target itself)
     * @return a {@link String} object representing the source. This string representation is the one from Target
     * with no formatting applied. It's the caller's job to map this source name to actual solution names (e.g. for
     * Target the source is {@code tnt})
     */
    public String getSource() {
        return origin;
    }

    public void setSource(String source) {
        this.origin = source;
    }

    @Override
    public String toString() {
        return "[" + getClass().getSimpleName() + " id: " + getId() + ", name: " + getName() + "]";
    }

}
