/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget;

import java.util.Set;

import aQute.bnd.annotation.ConsumerType;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;

/**
 * Provides location names for locations to be synchronized to Adobe Target
 */
@ConsumerType
public interface TargetLocationNameProvider {

    /**
     * Provides the name of the locations (mboxes) that will be synchronized to Target.
     *
     * This method returns a list of location names because one offer can run into multiple locations - same content but different pages.
     *
     * @param offerPage the offer page that runs on that location
     * @param wcmMode the {@link WCMMode}
     * @return a {@link Set} containing the generated names of the locations.
     */
    Set<String> getOfferLocationNames(Page offerPage, WCMMode wcmMode);

}
