/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.Map;

import aQute.bnd.annotation.ProviderType;

@ProviderType
public interface TestandtargetHttpClient {

    /**
     * Http method used in the API call
     *
     */
    public enum TestandtargetMethodType {
        GET, POST, PUT, DELETE, PATCH
    }

    /**
     * Solution to be called either Target or Target Recommendations
     */
    public enum TestandtargetSolution {
        TARGET, RECOMMENDATIONS;
    }

    /**
     * Executes a GET request with the provided query keys/values on the
     * configured Adobe Target API URL.
     *
     * @param queryKey
     *            Query keys
     * @param queryValues
     *            Query values
     * @return String representation of the API Response
     * @throws TestandtargetException {@link TestandtargetException}
     */
    String execute(String[] queryKey, String[] queryValues) throws TestandtargetException;

    /**
     * Executes a GET request against the Adobe Target REST API
     *
     * @param clientCode the clientCode to use, used to discover the T&amp;T endpoint to use
     * @param location the location to request, for instance <tt>segments/1.json</tt>
     * @param parameters query parameters
     * @return String representation of the API Response
     * @throws TestandtargetException {@link TestandtargetException}
     */
    String executeRestGetCall(String clientCode, String location, Map<String, String> parameters)
            throws TestandtargetException;

    /**
     * Executes a GET request against the Adobe Target REST API
     *
     * @param options a {@link com.day.cq.analytics.testandtarget.TestandtargetCallOptions} object containing the
     *                call options
     * @return String representation of the API Response
     * @throws TestandtargetException {@link TestandtargetException}
     */
    String executeRestGetCall(TestandtargetCallOptions options) throws TestandtargetException;

    /**
     * Executes a request using the provided query keys and values on the configured Adobe Target API URL
     *
     * @param callMethod - a {@link TestandtargetMethodType} indicating the method to be executed for the call (GET, POST, PUT or DELETE)
     * @param solution - the solution to be called, either Target or Target Recommendations
     * @param parameters - a {@link TestandtargetHttpParameters} containing the call parameters
     * @return String representation of the API Response
     * @throws TestandtargetException {@link TestandtargetException}
     */
    String execute(TestandtargetMethodType callMethod, TestandtargetSolution solution, TestandtargetHttpParameters parameters)
            throws TestandtargetException;

    /**
     * Executes a call against the Adobe Target REST API
     *
     * @param callMethod - a {@link TestandtargetMethodType} indicating the method to be executed for the call (GET, POST, PUT or DELETE)
     * @param clientCode the clientCode to use, used to discover the T&amp; T endpoint to use
     * @param location the location to request, for instance <tt>segments/1.json</tt>
     * @param solution - the solution to be called, either Target or Target Recommendations
     * @param parameters - a {@link TestandtargetHttpParameters} containing the call parameters
     * @return String representation of the API Response
     * @throws TestandtargetException {@link TestandtargetException}
     */
    String executeRestCall(TestandtargetMethodType callMethod, String clientCode, String location, TestandtargetSolution solution, TestandtargetHttpParameters parameters)
            throws TestandtargetException;

    /**
     * Executes a call against the Adobe Target REST API
     * @param options a {@link com.day.cq.analytics.testandtarget.TestandtargetCallOptions} object containing the
     *                call options
     * @return a {@link String} representation of the API response.
     * @throws TestandtargetException {@link TestandtargetException}
     */
    String executeRestCall(TestandtargetCallOptions options) throws TestandtargetException;

    /**
     * Returns the configured timeout in milliseconds until a connection is
     * established. A timeout value of 0 is interpreted as an infinite timeout.
     * 
     * @return Timeout in milliseconds. If value is not configured a default timeout
     *         is returned.
     */
    int getConnectionTimeout();

    /**
     * Returns the configured timeout in milliseconds, which is the timeout for
     * waiting for data or a maximum period of inactivity between two consecutive
     * data packets. A timeout value of 0 is interpreted as an infinite timeout.
     * 
     * @return Timeout in milliseconds. If value is not configured a default timeout
     *         is returned.
     */
    int getSocketTimeout();

}
