/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/**
 * A <code>ListInfoProvider</code> enables injecting custom information into a JSON object
 */
public interface ListInfoProvider {

    /**
     * Update list global information with custom properties
     *
     * @param request  a sling http request object
     * @param info     the JSON object to update
     * @param resource a sling resource object
     *
     * @throws JSONException if updating list information failed
     */
    void updateListGlobalInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException;

    /**
     * Update list item information with custom properties
     *
     * @param request  a sling http request object
     * @param info     the JSON object to update
     * @param resource a sling resource object
     *
     * @throws JSONException if updating list information failed
     */
    void updateListItemInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException;

}