/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons;

import java.util.Iterator;

/**
 * Extends <code>Iterator<E></code> with the <code>skip</code>, <code>getSize</code>
 * and <code>getPosition</code> methods.
 */
public interface RangeIterator<E> extends Iterator<E> {

    /**
     * Skip a number of elements in the iterator.
     *
     * @param skipNum the non-negative number of elements to skip
     * @throws java.util.NoSuchElementException
     *          if skipped past the last element in the iterator.
     */
    public void skip(long skipNum);

    /**
     * Returns the number of elements in the iterator.
     * If this information is unavailable, returns -1.
     *
     * @return a long
     */
    public long getSize();

    /**
     * Returns the current position within the iterator. The number
     * returned is the 0-based index of the next element in the iterator,
     * i.e. the one that will be returned on the subsequent <code>next</code> call.
     * <p/>
     * Note that this method does not check if there is a next element,
     * i.e. an empty iterator will always return 0.
     *
     * @return a long
     */
    public long getPosition();
}
