/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.apache.sling.api.resource.ValueMap;

/**
 * Convenience base class for {@link ValueMap} implementations that
 * need to wrap an existing ValueMap instance.
 *
 */
public abstract class ValueMapWrapper implements ValueMap {
    
    private ValueMap base;
    
    public ValueMapWrapper(ValueMap map) {
        this.base = map;
    }

    public <T> T get(String name, Class<T> type) {
        return base.get(name, type);
    }

    public <T> T get(String name, T defaultValue) {
        return base.get(name, defaultValue);
    }

    public int size() {
        return base.size();
    }

    public boolean isEmpty() {
        return base.isEmpty();
    }

    public boolean containsKey(Object key) {
        return base.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return base.containsValue(value);
    }

    public Object get(Object key) {
        return base.get(key);
    }

    public Object put(String key, Object value) {
        return base.put(key, value);
    }

    public Object remove(Object key) {
        return base.remove(key);
    }

    public void putAll(Map<? extends String, ?> t) {
        base.putAll(t);
    }

    public void clear() {
        base.clear();
    }

    public Set<String> keySet() {
        return base.keySet();
    }

    public Collection<Object> values() {
        return base.values();
    }

    public Set<Entry<String, Object>> entrySet() {
        return base.entrySet();
    }

    @Override
    public String toString() {
        return super.toString() + " : " + this.base.toString();
    }
}
