/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.inherit;

import org.apache.sling.api.resource.ValueMap;

/**
 * The <code>InheritanceValueMap</code> is an extension of the {@link ValueMap}
 * which allows to take the hierarchy of resources into account while looking
 * for properties. As such, if a property is not found on the current resource,
 * it will be looked up on its parent and so on. The exact inheritance mechanism
 * depends on the implementation.
 * 
 * <p>
 * For this purpose, the additional methods {@link #getInherited(String, Class)}
 * and {@link #getInherited(String, Object)} are added to the ValueMap
 * interface.
 */
public interface InheritanceValueMap extends ValueMap {

    /**
     * Get a named property and convert it into the given type, and take the
     * properties of parent resources / pages into account, if the property is
     * not found locally.
     * 
     * <p>
     * The exact inheritance mechanism depends on the implementation.
     * 
     * @param name
     *            The name of the property
     * @param type
     *            The class of the type
     * @return Return named value converted to type T or <code>null</code> if
     *         non existing or can't be converted.
     */
    <T> T getInherited(String name, Class<T> type);

    /**
     * Get a named property and convert it into the given type, and take the
     * properties of parent resources / pages into account, if the property is
     * not found locally.
     * 
     * <p>
     * The exact inheritance mechanism depends on the implementation.
     * 
     * @param name
     *            The name of the property
     * @param defaultValue
     *            The default value to use if the named property does not exist
     *            or cannot be converted to the requested type. The default
     *            value is also used to define the type to convert the value to.
     *            If this is <code>null</code> any existing property is not
     *            converted.
     * @return Return named value converted to type T or the default value if
     *         non existing or can't be converted.
     */
    <T> T getInherited(String name, T defaultValue);
}
