/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.commons.predicate;

import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.Resource;
/**
 * Predicate used to filter sling Resource
 *
 */
abstract public class AbstractResourcePredicate implements Predicate {
    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if o is a Resource the subsequent call to {@link #evaluate(Resource)}
     * returns <code>true</code>; <code>false</code> otherwise.
     */
    public boolean evaluate(Object o) {
        if (o != null && o instanceof Resource) {
            return evaluate((Resource) o);
        } 
        //return true if this predicate does not know how to evaluate it.
        return true;
    }

    /**
     * Evaluates this predicate on the given Resource.
     *
     * @param resource given resource
     * @return <code>true</code> if this resource satisfies this predicate
     */
    public abstract boolean evaluate(Resource res);
}
