/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.predicate;

import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Predicate used to filter payload resources.
 */
@Component(metatype = false)
@Service(Predicate.class)
@Properties({
        @Property(name = "predicate.name", value = "nosystem")
})
public class IsNoSystemNodePredicate extends AbstractNodePredicate implements Predicate {

    /**
     * private list of excludes.
     */
    private static final Set<String> EXCLUDES = new HashSet<String>(
            Arrays.asList("jcr:system", "rep:policy"));

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if the node's name is not jcr:system or
     *         rep:policy
     */
    public boolean evaluate(Node node) throws RepositoryException {
        return !EXCLUDES.contains(node.getName());
    }
}
