/**
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.compat.codeupgrade;

/** A service that executes a code upgrade.
 *  From CQ5.6 on, such services are executed by the 
 *  cq-upgrades-executor bundle Activator, 
 *  synchronously when that bundle starts.
 */ 
public interface CodeUpgradeTask extends Runnable {
    /** True if an upgrade is needed */
    public boolean upgradeNeeded();
    
    /** Called to cancel an upgrade that might be in progress */
    public void cancelUpgrade();
    
    /** Return upgrade progress info */
    public String getProgressInfo();
}
