/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.contentsync;

/**
 * The <code>ContentSyncConstants</code> interface defines node type,
 * resource type and property names used throughout content sync.
 */
public interface ContentSyncConstants {

    /** Default config entry order if one is not specified */
    public static final long DEFAULT_CONFIG_ENTRY_ORDER = 0;

	/** Node type of a config */
	public static final String NT_CONTENT_SYNC_CONFIG = "cq:ContentSyncConfig";

	/** Resource type of a config */
	public static final String RT_CONTENT_SYNC_CONFIG = "contentsync/config";

    /** Property name of a config's mandatory source path */
    public static final String PN_AUTHORIZABLE = "authorizable";

    /** Property name of a config's mandatory source path */
    public static final String PN_UPDATE_USER = "updateUser";

    /** Property name of a config's mandatory source path */
    public static final String PN_PERSONALIZED = "personalized";

	/** Property name of a config entry's mandatory type */
	public static final String PN_TYPE = "type";

	/** Property name of a config entry's mandatory source path */
	public static final String PN_PATH = "path";

    /** Property name of a config entry's order */
    public static final String PN_ORDER = "order";
}
