/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.contentsync.handler;

import com.day.cq.contentsync.config.ConfigEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDefaultContentUpdateHandler implements ContentUpdateHandler{
    public static final String CONFIG_TARGET_PATH_PREFIX = "targetRootDirectory";

    private static final Logger log = LoggerFactory.getLogger(AbstractDefaultContentUpdateHandler.class);

    protected String getConfigCacheRoot(ConfigEntry configEntry, String configCacheRoot){
        String prefixPath = configEntry.getValue(CONFIG_TARGET_PATH_PREFIX);
        if(prefixPath!=null){
            return configCacheRoot + "/" + prefixPath;
        }
        return configCacheRoot;
    }

    /**
     * Get content path and resolve path if relative.
     *
     * @param configEntry
     * @return resolved path for ConfigEntry's contentPath
     */
    protected String getResolvedContentPath(ConfigEntry configEntry){
        String configuredContentPath = configEntry.getContentPath();
        String contentPath = configuredContentPath;
        if(configuredContentPath.startsWith("..") || configuredContentPath.startsWith(".")){
            contentPath = configEntry.getPath() + "/" + configuredContentPath;
            log.debug("Configured path '" + configuredContentPath + "' resolved to '" + contentPath + "'");
        }
        return contentPath;
    }
}