/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.contentsync.handler;

import javax.jcr.Session;

import com.day.cq.contentsync.config.ConfigEntry;

/**
 * Interface for Content Sync cache update handlers. Custom handlers
 * should implement this interface and register as OSGi component factory.
 */
public interface ContentUpdateHandler {
	/**
	 * This method should update the content sync cache for
	 * the given <code>ConfigEntry</code>. If the cache entry
	 * is missing or the content has changed relative to the
	 * given date, the handler should create/update the cache
	 * entry and indicate the update by returning <code>true</code>.
	 * @param configEntry		The config entry
	 * @param lastUpdated		The last update cache timestamp
	 * @param configCacheRoot	The path to cache root
	 * @param admin				The admin session for cache updates
	 * @param session			The user session for personalized content
	 * @return <code>true</code> if cache was updated, <code>false</code> otherwise
	 */
	public boolean updateCacheEntry(ConfigEntry configEntry, Long lastUpdated, String configCacheRoot, Session admin, Session session);
}
