/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api;

/**
 * The <code>RenditionPicker</code> interface specifies retrieving an arbitrary asset rendition via custom
 * implementations.
 */
public interface RenditionPicker {

    /**
     * Returns the desired rendition {@link Rendition} if existing, otherwise <code>null</code>.
     * <p/>
     * Implementations are free to decide which rendition is chosen when this method is called.
     * <p/>
     * The rendition shall be searched for within the given {@link Asset}.
     * <p/>
     * Example implementation:
     * <blockquote><pre>
     *  ...
     *  public Resource getRendition(Asset asset) {
     *      // 1. try to get a web enabled rendition
     *      List<Resource> renditions = asset.getRenditions();
     *      for (Resource rendition: renditions) {
     *          if (Text.getName(rendition.getPath()).startsWith("cq5dam.web.")) {
     *              return rendition;
     *          }
     *      }
     *      // 2. return current rendition
     *      return asset.getCurrentOriginal();
     *  }
     *  ...
     * </pre></blockquote>
     *
     * @param asset The <code>Asset</code> within which to search the rendition.
     * @return the desired rendition if existing, otherwise <code>null</code>
     */
    Rendition getRendition(Asset asset);
}
