/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api.cache;

import java.awt.image.BufferedImage;
import java.io.IOException;

import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;


/**
 * The <code>BufferedImageCache</code> interface defines a cache that is
 * supposed to cache BufferedImages which are intended to be used more than once
 * very quickly (e.g. Asset import). The impl. must make sure that the cache
 * won't take too much memory from the overall jvm memory "pool" and that images
 * won't life for ages in the cache.
 */
public interface BufferedImageCache {

    /**
     * Returns the image for the given rendition. If the image is not in the
     * cache, the asset handler is used to load the image.
     * <p>
     * This method always returns a copy of the buffered image. Returns null if
     * param rendition is null.
     *
     * @param rendition of the image.
     * @param handler the asset handler that will load the image if not in cache.
     *
     * @return a cache entry which is already acquired. Consumers of the entry
     *         need to call {@link Entry#release()} if they are done using the
     *         buffered image in order to free system resources.
     * @throws IOException if an error occurs
     */
    Entry getImage(Rendition rendition, AssetHandler handler) throws IOException;

    interface Entry {

        BufferedImage getImage();

        void acquire();

        void release();

        long getSize();
    }
}