/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.checkout;

import com.day.cq.dam.api.Asset;

import aQute.bnd.annotation.ProviderType;

/**
 * OSGi service that allows to check in and check out assets.
 */
@ProviderType
public interface AssetCheckoutService {


    /**
     * Return a flag indicating whether the current user can check out the asset.
     *
     * @param asset Asset
     * @return <code>true</code> if the asset can be checked out;
     *         <code>false</code> otherwise
     */
    boolean canCheckOut(Asset asset);

    /**
     * Check out an asset.
     *
     * @param asset Asset
     * @throws IllegalStateException if the asset is already checked out or cannot be checked out by the current user.
     */
    void checkOut(Asset asset) throws IllegalStateException;

    /**
     * Checks if this asset is checked out.
     *
     * @param asset Asset
     * @return <code>true</code> if this asset is checked out.
     */
    boolean isCheckedOut(Asset asset);

    /**
     * Return the user who has checked out the asset.
     *
     * @param asset Asset
     * @return Checkout user; <code>null</code> if the asset is not checked out
     */
    String getCheckedOutBy(Asset asset);

    /**
     * Return a flag indicating whether the current user can check in the asset.
     *
     * @param asset Asset
     * @return <code>true</code> if the asset can be checked in;
     *         <code>false</code> otherwise
     */
    boolean canCheckIn(Asset asset);

    /**
     * Check in an asset.
     *
     * @param asset Asset
     * @throws IllegalStateException if the asset is not checked out or cannot be checked in by the current user.
     */
    void checkIn(Asset asset) throws IllegalStateException;

}
