/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api.handler.store;

import com.day.cq.dam.api.handler.AssetHandler;

/**
 * The <code>AssetHandlerInfo</code> class ...
 *
 * @deprecated since 5.4
 */
@Deprecated
public interface AssetHandlerInfo {

    /**
     * Get the corresponding media handler.
     */
    AssetHandler getMediaHandler();

    /**
     * Get the service name.
     */
    String getName();

    /**
     * Get the service id.
     */
    String getServiceId();

    /**
     * Get the class name.
     */
    String getClassName();

    /**
     * Return the list of mime types supported by this media handler.
     * @return The list of mime types or an empty list.
     */
    String[] getMimeTypes();

    /**
     * Return the list of currently active mime types for this media handler.
     * @return The list of mime types or an empty list.
     */
    String[] getActiveMimeTypes();

    /**
     * Return the list of currently inactive mime types for this media handler.
     * @return The list of mime types or an empty list.
     */
    String[] getInactiveMimeTypes();

    /**
     * Activate the media handler for the given mime type.
     * If the media handler does not support the mime type, no action is performed.
     * If another media handler is currently activated for the mime type, it gets
     * deactivated. Only one media handler can be activate at a time for a mime type.
     */
    void activate(String mimeType);

    /**
     * Deactivate the media handler for the given mime type.
     * If the media handler does not support the mime type, no action is performed.
     * If there is another handler for the same mime type that one is not
     * activated automatically. This has to be done manually by {@link #activate(String)}.
     */
    void deactivate(String mimeType);

    /**
     * Is this a configurable media handler?
     *
     */
    boolean hasConfiguration();

}
