/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.cq.dam.api.handler.xmp;

import com.day.cq.dam.api.Asset;
import com.adobe.xmp.XMPMeta;
import java.io.IOException;
import com.adobe.xmp.core.XMPMetadata;

/**
 * The <code>XMPHandler</code> interface defines the functionality needed to read and write XMP meta info to
 * and from Asset.
 * There can be only one active implementation at any given time. Highest ranked service will be used if more than one
 * implementations are available.
 */
public interface XMPHandler {

    /**
     * Checks if the provided mime type is supported by the implementation
     * @param mimeType to be checked
     * @return true if the given mime type is supported
     * */
    boolean isSupported(String mimeType);

    /**
     * Read xmp packet from the original binary
     * @param asset
     * @return XMPMeta
     * @throws IOException if fails to read xmp
     * */
    @Deprecated
    XMPMeta readXmp(Asset asset) throws IOException;

    /**
     * Read xmp packet from the original binary
     * @param asset
     * @return XMPMetaData
     * @throws IOException if fails to read xmp
     * */
    XMPMetadata readXmpMetadata(Asset asset) throws IOException;
    
    /**
     * Write xmp bytes back to the original binary
     * @param asset
     * @param xmpBytes
     * @throws IOException if fails to write back xmp to the binary
     * */
    void writeXmp(Asset asset, byte[] xmpBytes) throws IOException;

    /**
     * Write xmp meta back to the original binary
     * @param asset
     * @param xmpMeta object
     * @throws IOException if fails to write back xmp to the binary
     * */
    @Deprecated
    void writeXmp(Asset asset, XMPMeta xmpMeta) throws IOException;
    /**
     * Write xmp bytes back to the original binary
     * @param asset
     * @param xmpBytes
     * @param createVersion if true then create versions of the asset on each writeback
     * @throws IOException if fails to write back xmp to the binary
     * @deprecated use {@link XMPHandler#writeXmp(Asset, byte[], XMPWriteBackOptions)} instead
    */
    void writeXmp(Asset asset, byte[] xmpBytes, boolean createVersion) throws IOException;

    /**
     * Write xmp meta back to the original binary
     * @param asset
     * @param xmpMeta object
     * @param createVersion if true then create versions of the asset on each writeback
     * @throws IOException if fails to write back xmp to the binary
     * @deprecated use {@link XMPHandler#writeXmp(Asset, XMPMeta, XMPWriteBackOptions)} instead
    */
    void writeXmp(Asset asset, XMPMeta xmpMeta, boolean createVersion) throws IOException;
    
    /**
     * Write xmp bytes back to the original/renditions' binary
     * @param asset
     * @param xmpBytes
     * @param writeBackOptions the XMP write back options 
     * @throws IOException if fails to write back xmp to the binary
     * */
    void writeXmp(Asset asset, byte[] xmpBytes, XMPWriteBackOptions writeBackOptions) throws IOException;

    /**
     * Write xmp meta back to the original binary
     * @param asset
     * @param xmpMetadata object
     * @param writeBackOptions the XMP write back options
     * @throws IOException if fails to write back xmp to the binary
     * */
     void writeXmpMetadata(Asset asset, XMPMetadata xmpMetadata, XMPWriteBackOptions writeBackOptions) throws IOException;

    /**
     * Write xmp meta back to the original/renditions' binary
     * @param asset
     * @param xmpMeta object
     * @param writeBackOptions the XMP write back options
     * @throws IOException if fails to write back xmp to the binary
     * */
    void writeXmp(Asset asset, XMPMeta xmpMeta, XMPWriteBackOptions writeBackOptions) throws IOException;
}
