/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.jobs;

import org.apache.sling.api.resource.Resource;
import aQute.bnd.annotation.ProviderType;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;

@ProviderType
public interface AssetDownloadService {
    /**
     * Test URL params to see if this request should go to S7 (has image format or image presets)
     *
     * @param configResource     Resource
     * @param downloadSet        Set<Resource>: Set of JcrNodeResource, which includes assets' info
     * @param downloadAssets     boolean
     * @param downloadRenditions boolean
     * @param downloadSubassets  boolean
     * @param s7ExportSettings   String: it could be an imagePreset or a string of several modifiers; No s7export if this is null
     * @param date               Date: the export could be scheduled or execute immediately if this is null
     * @param out                ZipOutputStream, pass the output stream filter for the archive downloading
     * @param downloadName       String: download job name
     * @param emailRecipients    String: email recipients
     * @return String: downloadUrl if the archive file is stored in jcr
     */
    String assetDownload(final Resource configResource, Set<Resource> downloadSet, boolean downloadAssets, boolean downloadRenditions, boolean downloadSubassets, String s7ExportSettings, Date date, ZipOutputStream out, String downloadName, String emailRecipients);

    /**
     * Computes uncompressed size of assets requested for download
     * @param params asset download options
     * @return long: (uncompressed) size of the content requested for download (in bytes)
     */
    long computeAssetDownloadSize(AssetDownloadParams params);
    
    /**
     * Test URL params to see if this request should go to S7 (has image format or image presets)
     * @param params asset download options
     * @return String: downloadUrl if the archive file is stored in jcr
     */
    String assetDownload(AssetDownloadParams params);

    /**
     * parameter class for asset download service
     */
    static class AssetDownloadParams {

        private Resource configResource;

        /**
         * Set of JcrNodeResource, which includes assets' info
         */
        private Set<Resource> downloadSet;

        /**
         * when true assets aee downloaded
         */
        private boolean downloadAssets;

        /**
         * when true renditions of assets are downloaded
         */
        private boolean downloadRenditions;

        /**
         * when true subaasets are downloaded
         */
        private boolean downloadSubassets;

        /**
         * it could be an imagePreset or a string of several modifiers; No s7export if this is null
         */
        private String s7ExportSettings;

        /**
         * the export could be scheduled or execute immediately if this is null
         */
        private Date date;

        /**
         * ZipOutputStream, pass the output stream filter for the archive downloading
         */
        private ZipOutputStream zipOutputStream;

        /**
         * download job name
         */
        private String downloadName;
        private String emailRecipients;

        /**
         * if download should have flat file structure
         */
        private boolean flatStructure;

        /**
         * Permissions/privileges the resource resolver should have in order to download the resource(s)
         */
        private List<String> permissions;

        public AssetDownloadParams(Resource configResource, Set<Resource> downloadSet, boolean downloadAssets, boolean downloadRenditions, boolean downloadSubassets, String s7ExportSettings, Date date, ZipOutputStream zipOutputStream, String downloadName, String emailRecipients, boolean flatStructure, List<String> permissions) {
            this.configResource = configResource;
            this.downloadSet = downloadSet;
            this.downloadAssets = downloadAssets;
            this.downloadRenditions = downloadRenditions;
            this.downloadSubassets = downloadSubassets;
            this.s7ExportSettings = s7ExportSettings;
            this.date = date;
            this.zipOutputStream = zipOutputStream;
            this.downloadName = downloadName;
            this.emailRecipients = emailRecipients;
            this.flatStructure = flatStructure;
            this.permissions = permissions;
        }

        public Resource getConfigResource() {
            return configResource;
        }

        public Set<Resource> getDownloadSet() {
            return downloadSet;
        }

        public boolean isDownloadAssets() {
            return downloadAssets;
        }

        public boolean isDownloadRenditions() {
            return downloadRenditions;
        }

        public boolean isDownloadSubassets() {
            return downloadSubassets;
        }

        public String getS7ExportSettings() {
            return s7ExportSettings;
        }

        public Date getDate() {
            return date;
        }

        public ZipOutputStream getZipOutputStream() {
            return zipOutputStream;
        }

        public String getDownloadName() {
            return downloadName;
        }

        public String getEmailRecipients() {
            return emailRecipients;
        }

        public boolean isFlatStructure() {
            return flatStructure;
        }

        public List<String> getPermissions() {
            return permissions;
        }
    }
}
