/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api.lightbox;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;

import javax.jcr.RepositoryException;
import java.util.List;

/**
 * The <code>Lightbox</code> interface provides all needed functionality
 * in order to "manage" the user's lighboxes.
 */
public interface Lightbox {

    /**
     * Adds the original rendition of the asset to the user's lightbox.
     *
     * @param asset Asset
     * @throws javax.jcr.RepositoryException in case an exception occurs while
     * adding the file.
     */
    void add(Asset asset) throws RepositoryException;

    /**
     * Adds the rendition of the asset to the user's lightbox.
     *
     * @param rendition Rendition
     * @throws javax.jcr.RepositoryException in case an exception occurs while
     * adding the file.
     */
    void add(Rendition rendition) throws RepositoryException;
    
    /**
     * Removes a lightbox entry.
     *
     * @param name Name of the entry (node name)
     * @throws RepositoryException in case an exception occurs while removing an
     * entry.
     */
    void remove(String name) throws RepositoryException;

    /**
     * Removes all lightbox entries.
     *
     * @throws RepositoryException in case an exception occurs while removing an
     * entry.
     */
    void clear() throws RepositoryException;

    /**
     * Lists all entries from the lightbox. The list contains the path of
     * each entry.
     *
     * @return list of all lightbox entries
     *
     * @throws RepositoryException in case an exception occurs while fetching
     * the entries.
     */
    List<String> getEntries() throws RepositoryException;

    /**
     * Checks if the asset of the given path is contained in the lightbox .
     *
     * @param asset The asset to check
     * @return true if contained in the lightbox, otherwise false
     * @throws RepositoryException in case an exception occurs while checking
     * the entries.
     */
    boolean contains(Asset asset) throws RepositoryException;
    
    /**
     * Checks if the rendition of the given path is contained in the lightbox .
     *
     * @param rendition The rendition to check
     * @return true if contained in the lightbox, otherwise false
     * @throws RepositoryException in case an exception occurs while checking
     * the entries.
     */
    boolean contains(Rendition rendition) throws RepositoryException;
    
    
    /**
     * Return path of referenced asset in /content/dam for the lightbox entry else return null.
     * 
     * @return the path of referenced asset.
     * @throws RepositoryException
     */
    @Deprecated 
    String getAssetReference(String path) throws RepositoryException;
    
    /**
     * Return path of referenced asset or rendition in /content/dam for the lightbox entry else return null.
     * 
     * @return the path of referenced asset or rendition.
     * @throws RepositoryException
     */
    String getReference(String path) throws RepositoryException;

}
