/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api.lightbox;

import javax.jcr.Session;

/**
 * The <code>LightboxService</code> makes sure that access to the respective
 * user lightboxes is possible.
 */
public interface LightboxService {

    /**
     * Returns the {@link Lightbox} of the respective user (userSession).
     *
     * @param userSession user session
     * @return the user's {@link Lightbox}
     */
    Lightbox getLightbox(Session userSession);
    
    /**
     * Returns the {@link Lightbox} containing resource located at resourcePath. 
     * It returns null if resource is not found or resource is not contained 
     * within lightbox.
     * 
     * @param session jcr session
     * @param resourcePath path of the resource
     * @return the resource's {@link Lightbox} or null
     */
    Lightbox getLightbox(Session session, String resourcePath);
}
