/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api.metadata;

import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.io.InputStream;
import java.io.File;

/**
 * The <code>ExtractedMetadata</code> class ...
 */
public class ExtractedMetadata {/**
     * Metadata properties
     */
    private Map metaDataProperties;

    /**
     * xmp data
     */
    private InputStream xmp;

    /**
     * Temp files
     */
    private List temporaryFiles;

    /**
     * Property map
     */
    private Map properties;

    public ExtractedMetadata() {
        this.metaDataProperties = new HashMap();
    }

    /**
     * Returns the metadata properties
     *
     * @return metadata properties
     */
    public Map getMetaDataProperties() {
        return this.metaDataProperties;
    }

    /**
     * Returns the metadata object defined by its key
     *
     * @param key metadata property key
     *
     * @return metadata object
     */
    public Object getMetaDataProperty(String key) {
        return this.metaDataProperties.get(key);
    }

    /**
     * Set meta data
     *
     * @param key the metadata property key
     * @param value the corresponding value
     */
    public void setMetaDataProperty(String key, Object value) {
        this.metaDataProperties.put(key, value);
    }

    /**
     * Add a map of additional metadata properties
     *
     * @param props map of properties
     */
    public void addMetadataProperties(Map props) {
        this.metaDataProperties.putAll(props);
    }

    /**
     * Set the xmp data
     *
     * @param xmp xmp data
     */
    public void setXmp(InputStream xmp) {
        this.xmp = xmp;
    }

    /**
     * Get xmp data
     *
     * @return xmp data
     */
    public InputStream getXmp() {
        return this.xmp;
    }

    /**
     * Add temp file which is used in the metadata extraction method.
     *
     * @param tmpFile temp file
     */
    public void addTemporaryFileForCleanup(File tmpFile) {
        if ( this.temporaryFiles == null ) {
            this.temporaryFiles = new ArrayList();
        }
        this.temporaryFiles.add(tmpFile);
    }

    /**
     * Deletes all used temp files
     */
    public void cleanup() {
        if ( this.temporaryFiles != null ) {
            final Iterator i = this.temporaryFiles.iterator();
            while ( i.hasNext() ) {
                final File current = (File)i.next();
                current.delete();
            }
            this.temporaryFiles = null;
        }
    }

    /**
     * Set property
     *
     * @param name property name
     * @param value property value
     */
    public void setProperty(String name, Object value)  {
        if ( this.properties == null ) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    /**
     * Get property
     *
     * @param name property name
     * @return property value
     */
    public Object getProperty(String name) {
        return (this.properties == null ? null : this.properties.get(name));
    }
}