/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.proxy.client;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.proxy.ProxyException;

import java.io.InputStream;
import java.util.Hashtable;

/**
 * <code>JobService</code> Interface defines methods to add/remove job and to
 * get status and result of an existing job
 * <p/>
 * 
 * @since 5.5
 */
@Deprecated
public interface JobService {

    static final int STATUS_INPROGRESS = 1;

    static final int STATUS_FINISHED = 0;

    static final int STATUS_ERROR = -1;
    
    /**
	 * This property defines the uniquie jobID for the proxy job. This can later
	 * be used by proxy job processor to do job specific processing.
	 */
    public static final String DAM_PROXY_JOB_NAME = "dam.proxy.job.name";

    /**
     * Posts a job to the Sling job queue. Depending on the implementation
     * either job is pushed in to a local queue or sent to the remote server to
     * be added.
     * 
     * @param properties, serializable properties to be added to the job
     * @param dependencies, array or asset(s) to be attached to the job
     * @return unique job id
     * @throws ProxyException in case implementation is unable to process this
     *             request
     */
    String addJob(Hashtable properties, Asset[] dependencies)
            throws ProxyException;

    /**
     * Posts a job to the Sling job queue. Depending on the implementation
     * either job is pushed in to a local queue or sent to the remote server to
     * be added. It takes additional parameter to specify the multipart filename
     * encoding.
     * 
     * @param properties, serializable properties to be added to the job
     * @param dependencies, array or asset(s) to be attached to the job
     * @param fileNameEncoding, encoding scheme name for the filename
     * @return unique job id
     * @throws ProxyException in case implementation is unable to process this
     *             request
     */
    String addJob(Hashtable properties, Asset[] dependencies,
            String fileNameEncoding) throws ProxyException;

    /**
     * @deprecated  As of release 5.6, replaced by {@link #getJobStatus()}
     * 
     * Get job status. Depending on the implementation, this will either search
     * for the jobs in local or remote queue.
     * 
     * @param jobId, for which status needs to be searched
     * @return int status
     * @throws ProxyException in case of any error
     */
    @Deprecated
    int getStatus(String jobId) throws ProxyException;
    
    /**
     * Get job status as string, implementation decided on the format. 
     * 
     * Depending on the implementation, this will either search
     * for the jobs in local or remote queue.
     * 
     * @param jobId, for which status needs to be searched
     * @return status as string
     * @throws ProxyException in case of any error
     */
    String getJobStatus(String jobId) throws ProxyException;
    
    /**
     * Get result as a string, implementation decides on the format.
     * Responsibility of creating a result is delegated to the job processor.
     * 
     * @param jobId, for which the result needs to be read
     * @return result as string
     * @throws ProxyException in case of any error
     */
    String getResult(String jobId) throws ProxyException;

    /**
     * Get a single resource associated with the given job, either local or
     * remote.
     * 
     * @param jobId, for which resource needs to be searched
     * @param resourcePath, to be searched
     * @return resource as stream
     * @throws ProxyException in case of any error
     */
    InputStream getResource(String jobId, String resourcePath)
            throws ProxyException;

    /**
     * Remove job and cleanup all related resources for the given job.
     * 
     * @param jobId, for which the job needs to be removed
     * @throws ProxyException if the job cannot be removed
     */
    void removeJob(String jobId) throws ProxyException;
}
