/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.s7dam.jobs;

import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;

import org.apache.sling.api.resource.Resource;

import com.day.cq.dam.api.Asset;

public interface S7damExportService {
	
    /**
     * The DAM export job type.
     */
	public static final String S7_PRESET = "downloadS7Assets";
	
    /**
     * S7dam Export.
     * @param configResource 
     *          The cloud config resource
     * @param assets
     *          type: Set<Asset> (the export assets)
     * @param s7ExportSettings
     *          type: String: It could be an imagePreset or a string of several modifiers
     * @param exportJobName
     *          type: String
     * @return String 
     *          hosted: returns a JCR node name. It is for getting the updated export job status if it is done successfully.
     *          onprem: returns an empty string.
     */	
	String export(final Resource configResource, Set<Asset> assets, String s7ExportSettings, String exportJobName);
	
    /**
     * Download assets with s7dam settings and write to the zip file.
     * @param fileLocations
     *          type: List<String> (the url to get the S7 asset(s) bytes)
     * @param assets
     *          type: Set<Asset> (to save the S7 assets to their corresponding folders by the export file names)
     * @param s7ExportSettings
     *          type: String: It could be an imagePreset or a string of several modifiers
     * @param zo
     *          type: ZipOutputStream (the export zip out stream)
     * @param configResource 
     *          config resource
     * @return boolean 
     */ 
	boolean downloadAndExtractFiles (List<String> fileLocations, Set<Asset> assets, String s7ExportSettings, ZipOutputStream zo, final Resource configResource, Boolean flatStructure);

    /**
     * Get the downloadUrls that points to the exported archive file.
     * @param jcrPath
     *          type: String 
     *          value (hosted): it is used to fetch the downloadUrl which is generated after a S7 export job
     *                (onprem): it is an empty string
     * @param assets
     *          type: Set<Asset> (the export assets with the path info)
     * @param s7ExportSettings
     *          type: String: It could be an imagePreset or a string of several modifiers
     * @param configResource 
     *          config resource
     * @param flatStructure
     * 			type: boolean indicating whether or not to create subfolders for dynamic media assets
     * @return List<String>
     */
    public List<String> getExportUrls(String jcrPath, Set<Asset> assets, String s7ExportSettings, final Resource configResource);
    
    /**
     * Clean up the job's info from jcr after the job is done.
     * @param configResource 
     *          The cloud config resource
     * @param nodeName
     *          type: String: the name of the jcrNode that saved the S7 downloadUrl 
     * @return void
     */
    public void removeJobStatusNode(final Resource configResource, String nodeName);
}
