/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.s7dam.utils;

import org.apache.sling.api.resource.Resource;

import javax.jcr.RepositoryException;

/**
 * Utility to help viewers create urls pointing to production publish dc's
 *
 * Created by agangam on 7/21/14.
 */
public interface PublishUtils {

    /**
     * Retrieve the publish node URL from the replication agent.
     * NOTE: This URL does not include the context path of the publish node!
     *
     * @param resource Resource for an asset
     * @return Publish root path
     * @throws RepositoryException
     */
    String getPublishNodeURL(Resource resource) throws RepositoryException;

    /**
     * Externalize an asset reference to a image delivery URL.
     * Will resolve to the Image Delivery cloud service if configured, otherwise it will resolve
     * to the publish node.
     *
     * @param resource Resource for an asset
     * @param assetPath Path to the asset in the JCR
     * @return Image Serving Delivery URL
     * @throws RepositoryException when an error occurs interacting with the repository
     */
    String externalizeImageDeliveryAsset(Resource resource, String assetPath) throws RepositoryException;

    /**
     * Externalize an image delivery URL
     *
     * The input url can be a relative path (e.g [/ctx]/is/image/[url]) or an absolute url
     * (e.g. http://[host]:[port]/[ctx]/is/image/[url]).
     *
     * The method will direct the url to the Image Delivery cloud service if configured, if no Image Delivery
     * cloud service is configured the passed url will be returned back.
     *
     * @param resource Resource for an asset
     * @param url Image Delivery URL
     * @return Externalized Image Serving Delivery URL or url if Image Delivery cloud service is not configured.
     */
    String externalizeImageDeliveryUrl(Resource resource, String url) throws RepositoryException;

}