/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.api.ui.editor.metadata;

import java.util.List;

import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;

/**
 * The Interface MetadataEditorHelper. The interface holds the apis to support
 * functionalities related to metadata editor.
 * <p>
 * <b>Functionalities:</b>
 * </p>
 * <p>
 * 1. Form selection for asset and array of assets
 * </p>
 * <p>
 * 2. Mimetype of asset or common mimetype for multiple assets
 * </p>
 * <p>
 * 3. Validate metadata for the asset(s)
 * </p>
 */
public interface MetadataEditorHelper {

    /**
     * Gets the merged metadata-editor form which qualifies for the passed
     * Assets. It also looks for any folder specific metadata form which is
     * applicable for the asset. Folder specific metadata is priotorized over
     * mime type specific metadata.
     * <p>
     * Example:
     * </p>
     * <p>
     * If 2 assets are passed in the argument with mimetypes image/png and
     * image/jpg, the merged form will contain [default form + image form]
     * </p>
     * 
     * @param resources Array of asset resources for which form is to be fetched
     * @return the form resource
     * @throws SlingException may be thrown to convey any problem while fetching
     *             the form
     * @throws IllegalArgumentException if the method arguments are not
     *             compatible with the implementation details
     */
    public Resource getEditorFormResource(Resource... resources);

    /**
     * Checks if the resource has valid metadata present in the merged form. It
     * first fetches the synthetic resource form which qualifies for the
     * resource (Asset in most scenarios). Then it checks for all the form items
     * which are invalid. The criterion for invalidity is empty required field.
     * 
     * @param resource The Resource for which validity of metadata is to be
     *            checked.
     * @return List of form items for which metadata is invalid
     * @throws SlingException may be thrown to convey any problem while fetching
     *             the form
     * @throws IllegalArgumentException if the method arguments are not
     *             compatible with the implementation details
     */
    public List<Resource> getInvalidFormItems(Resource resource);
}
