/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.commons.handler;

import java.io.IOException;

/**
 * Continuously filter bytes and produce an output that can be read
 * back. Optionally pass processed bytes to a next filter.
 *
 * @author dpfister
 */
public interface Filter {

    /**
     * Filter a couple of bytes.
     *
     * @param buf buffer
     * @param off offset inside buffer
     * @param len number of bytes
     */
    public void filter(byte[] buf, int off, int len) throws IOException;

    /**
     * Reset the filter.
     */
    public void reset();

    /**
     * Set the flag indicating whether the filter automatically resets its
     * internal state when the end marker has been read.
     */
    public void setAutoReset(boolean autoReset);

    /**
     * Return a flag indicating whether the contents processed by this filter
     * represents a valid entity.
     *
     * @return <code>true</code> if the contents is valid;
     *         <code>false</code> otherwise.
     */
    public boolean isValid();
}
