/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.commons.proxy;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <code>ProxyUtil</code> provides methods and constants to be used by the job
 * processor and communication between <code>JobService</code> and
 * <code>ExternalJobPostServlet</code>
 * <p/>
 * 
 * @since 5.5
 */
@Deprecated
public abstract class ProxyUtil {

    private static final Logger log = LoggerFactory.getLogger(ProxyUtil.class);

    public static final String PATH_JOBS = "/var/proxy/jobs";

    public static final String PROPERTY_WORKING_DIR = "workingDir";

    private static final String RESULT_NODE = "result";
    
    private static final String STATUS_NODE = "status";

    // ----------- HTTP Servlet constants

    public static final String JOB_SERVLET = "/libs/dam/cloud/proxy";

    public static final String PARAMETER_FILE = "file";

    public static final String PARAMETER_JOB_ID = "jobid";

    public static final String PARAMETER_JOB_EVENT = "jobevent";

    public static final String PARAMETER_RESOURCE_PATH = "resourcePath";
    
    public static final String JOB_STATUS = "jobStatus";
    
    public static final String JOB_STATUS_CODE = "jobStatusCode";
    
    public static final String OPERATION = ":operation";
    
    public static final String OPERATION_JOB = "job";

    public static final String OPERATION_REMOVE = "remove";

    public static final String OPERATION_RESULT = "result";
    
    public static final String OPERATION_STATUS = "status";

    public static final String OPERATION_RESOURCE = "resource";

    public static String getJobsDir() {
        return PATH_JOBS;
    }

    public static String getWorkingDir(String jobId) {
        return new StringBuilder(PATH_JOBS).append("/").append(jobId).toString();
    }

    public static String getWorkingDir(Event event) {
        return (String) event.getProperty(PROPERTY_WORKING_DIR);
    }
    
    public static Node getOrCreateStatusNode(Node jobNode)
            throws RepositoryException {
        if (jobNode.hasNode(STATUS_NODE)) {
            return jobNode.getNode(STATUS_NODE);
        }
        return jobNode.addNode(STATUS_NODE, "nt:unstructured");
    }

    public static String getStatusNodePath(String jobId) {
        return new StringBuilder(PATH_JOBS).append("/").append(jobId).append(
            "/").append(STATUS_NODE).toString();
    }
    
    public static String getResultNodePath(String jobId) {
        return new StringBuilder(PATH_JOBS).append("/").append(jobId).append(
            "/").append(RESULT_NODE).toString();
    }

    public static Node getOrCreateResultNode(Node jobNode)
            throws RepositoryException {
        if (jobNode.hasNode(RESULT_NODE)) {
            return jobNode.getNode(RESULT_NODE);
        }
        return jobNode.addNode(RESULT_NODE, "nt:unstructured");
    }

    /**
     * Encode a string according to a specific encoding scheme.
     * 
     * @param str, string to be converted
     * @param encoding, name of the supported encoding scheme
     * @return the converted String
     */
    public static String getEncodedString(String str, String encoding)
            throws UnsupportedEncodingException {
        // Extra null check
        if (encoding == null) {
            return str;
        }
        return URLEncoder.encode(str, encoding);
    }

    /**
     * Decode a string according to a specific encoding scheme.
     * 
     * @param str, string to be converted
     * @param encoding, name of the supported encoding scheme
     * @return the converted String
     */
    public static String getDecodedString(String str, String encoding)
            throws UnsupportedEncodingException {
        // Extra null check
        if (encoding == null) {
            return str;
        }
        return URLDecoder.decode(str, encoding);
    }
}
