package com.day.cq.dam.commons.rating;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.tally.RatingComponent;
import com.adobe.cq.social.ugcbase.SocialUtils;


public class DamRatingComponent {
	
	private static final String RATINGS_PATH = "/ratings";
	
	private Resource assetResource;
	
	private RatingComponent ratingComponent;
	
	public DamRatingComponent (Resource assetResource) {
		this.assetResource = assetResource;
        ResourceResolver resolver = assetResource.getResourceResolver();
		final SocialUtils utils = resolver.adaptTo(SocialUtils.class);
        final String socoResourcePath = utils.resourceToUGCStoragePath(assetResource) + RATINGS_PATH;

		Resource socialResource = resolver.resolve(socoResourcePath);
		if (null != socialResource) {
			this.ratingComponent = socialResource.adaptTo(RatingComponent.class);
		}
	}

	public Resource getAssetResource() {
		return assetResource;
	}

	public RatingComponent getRatingComponent() {
		return ratingComponent;
	}

}
