/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.commons.sort;

import java.util.Iterator;
import java.util.List;

import org.apache.sling.api.resource.Resource;

/**
 * Service to sort {@link Resource}s by a column defined in
 * /libs/dam/gui/content/commons/availablecolumns.
 */
public interface ResourceSorter {

    /**
     * Sorts the given {@code resources} by the given {@code column} name. If
     * {@code reverse} is true, sorting gets reversed. {@code limit} and
     * {@code offset} define the range getting returned.
     * 
     * @param resources Resources to sort
     * @param column Column used as sort criteria
     * @param reverse If true result gets reversed
     * @param limit Max number of resources to return
     * @param offset Number of first resources not to return
     * @param filters node or mime types
     * @return
     */
    List<Resource> sort(Iterator<Resource> resources, String column,
            boolean reverse, int limit, int offset, String[] filters);

}