/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.commons.thumbnail;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.io.IOUtils;

import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.dam.api.DamConstants;
import com.day.image.Layer;

/**
 * The <code>ThumbnailCreator</code> class ...
 * @deprecated since 6.0, use {@link com.day.cq.dam.api.renditions.RenditionMaker} service instead
 */
@Deprecated
public class ThumbnailCreator {

    /**
     * This method creates all "needed" thumbnails.
     *
     * @param image
     *            picture file to create thumbnails from
     * @param renditionsFolder
     *            asset renditions folder node
     *
     * @param thumbnailConfigurations
     *
     * @throws java.io.IOException
     * @throws javax.jcr.RepositoryException
     */
    public void createThumbnails(BufferedImage image, Node renditionsFolder,
                                 List<ThumbnailConfig> thumbnailConfigurations)
            throws IOException, RepositoryException {
        File thumbnailtmpFile = null;

        try {
            thumbnailtmpFile = File.createTempFile("thumbnail", ".tmp");

            for (ThumbnailConfig d: thumbnailConfigurations) {
                FileOutputStream tout = null;
                InputStream is = null;
                int maxHeight = d.getHeight();
                int maxWidth  = d.getWidth();

                try {
                    tout = new FileOutputStream(thumbnailtmpFile);
                    Layer thumbnailLayer = creatThumbnail(image, maxWidth, maxHeight,
                            getExtension(renditionsFolder), d.isDoCenter());
                    thumbnailLayer.write(DamConstants.THUMBNAIL_MIMETYPE, 0.8, tout);

                    is = new FileInputStream(thumbnailtmpFile);
                    setThumbnail(renditionsFolder, is, d);
                } finally {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(tout);
                }
            }
            renditionsFolder.getSession().save();
        } finally {
            if (thumbnailtmpFile != null) {
                thumbnailtmpFile.delete();
            }
        }
    }

    /**
     * A thumbnail with the given <code>maxWith</code> and <code>maxHeight</code>
     * is generated out if the <code>image</code> source.
     *
     * @param image image source
     * @param maxWidth max. thumbnail width
     * @param maxHeight max. thumbnail height
     * @param extension file extension of (original asset). only used for the gif use case...//todo
     * @param doCenter <code>true</code> to center thumbnail
     * @return "thumbnailed" image as layer
     */
    public Layer creatThumbnail(BufferedImage image, int maxWidth, int maxHeight,
                                String extension, boolean doCenter) {
        Layer finalLayer = null;
        Layer layer = new Layer(image);

        int height = layer.getHeight();
        int width = layer.getWidth();
        Color bgColor = layer.getBackgroundColor();

        if (height > maxHeight || width > maxWidth) {
            // resize image
            int newWidth, newHeight;
            if (height > width) {
                newHeight = maxHeight;
                newWidth = (width * maxHeight / height);
                if (newWidth > maxWidth) {
                    newWidth = maxWidth;
                    newHeight = (height * maxWidth / width);
                }
            } else {
                newWidth = maxWidth;
                newHeight = (height * maxWidth / width);
                if (newHeight > maxHeight) {
                    newHeight = maxHeight;
                    newWidth = (width * maxHeight / height);
                }
            }
            layer.resize(newWidth, newHeight);
        }

        // merge and center image so that the "requested" height and width
        // are respected
        if ((layer.getHeight() < maxHeight || layer.getWidth() < maxWidth) && doCenter) {
            if (bgColor == null) {
                bgColor = Color.WHITE;
            }

            Color dummyColor =
                    (extension.equals("gif") ) ?
                            new Color(0xFFF0E0D0) : bgColor;   // Todo: really needed?
            finalLayer = new Layer(maxWidth,  maxHeight, dummyColor);
            finalLayer.setTransparency(dummyColor);
            int y = (maxHeight - layer.getHeight()) / 2;
            int x = (maxWidth - layer.getWidth()) / 2;
            layer.setX(x);
            layer.setY(y);
            finalLayer.merge(layer);
        }

        if (finalLayer == null) {
            return layer;
        } else {
            return finalLayer;
        }
    }

    public ThumbnailConfig createThumbnailConfig() {
        return new ThumbnailConfig();
    }

    /**
     * Thumbnail setter
     *
     * @param renditionsFolder
     *            asset renditions folder node
     * @param in
     *            thumbnail file input stream
     * @param thumbnailConf
     *
     * @throws RepositoryException
     */
    private void setThumbnail(Node renditionsFolder, InputStream in, ThumbnailConfig thumbnailConf)
            throws RepositoryException {

        if (renditionsFolder.hasNode(getThumbnailName(thumbnailConf))) {
            Node content = renditionsFolder.getNode(getThumbnailName(thumbnailConf) + "/" + JcrConstants.JCR_CONTENT);
            content.setProperty(JcrConstants.JCR_MIMETYPE, "image/png");
            content.setProperty(JcrConstants.JCR_DATA, content.getSession().getValueFactory().createBinary(in));
            content.setProperty(JcrConstants.JCR_LASTMODIFIED, Calendar.getInstance());
        } else {
            Node file = renditionsFolder.addNode(getThumbnailName(thumbnailConf), JcrConstants.NT_FILE);
            Node content = file.addNode(JcrConstants.JCR_CONTENT, JcrConstants.NT_RESOURCE);
            content.setProperty(JcrConstants.JCR_MIMETYPE, "image/png");
            content.setProperty(JcrConstants.JCR_DATA, content.getSession().getValueFactory().createBinary(in));
            content.setProperty(JcrConstants.JCR_LASTMODIFIED, Calendar.getInstance());
        }
    }

    /**
     * Create thumbnail name // TODO: this naming generator might be moved to some more common place
     * @param conf
     * @return
     */
    private String getThumbnailName(ThumbnailConfig conf) {
        String name = "cq5dam" + "." + "thumbnail";
        if (conf != null) {
            name += "." + String.valueOf(conf.getWidth()) + "." + String.valueOf(conf.getHeight()) + (conf.isDoCenter() ? ".margin" : "");
        }
        return name += ".png";
    }

    /**
     * Todo: realy, realy needed?
     * @param node
     * @return
     * @throws RepositoryException
     */
    private String getExtension(Node node) throws RepositoryException {
        String assetPath = node.getParent().getParent().getPath();
        return assetPath.substring(assetPath.lastIndexOf(".") + 1);
    }



    public class ThumbnailConfig {
        private int width;
        private int height;
        private boolean doCenter = true;


        public int getWidth() {
            return width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean isDoCenter() {
            return doCenter;
        }

        public void setDoCenter(boolean doCenter) {
            this.doCenter = doCenter;
        }
    }
}
