/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.commons.thumbnail.provider;

import com.day.cq.commons.thumbnail.ThumbnailProvider;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.commons.util.UIHelper;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

import java.util.Map;

/**
 * The <code>AssetThumbnailProvider</code> class ...
 */
@Component(metatype = false)
@Service
@Property(name = "thumbnail.provider.name", value = "dam:Asset")
public class AssetThumbnailProvider implements ThumbnailProvider {

    /** The fallback icon in case no thimbnail is available */
//    private static String DEFAULT_ASSET_ICON = "/libs/cq/ui/widgets/themes/default/icons/48x48/document.png";
    private static String DEFAULT_ASSET_ICON = "/libs/cq/ui/widgets/themes/default/icons/240x180/page.png";

    public String getThumbnailPath(Resource resource, int width, int height,
                                   Map<String, Object> additionalConf) {
        Asset asset = resource.adaptTo(Asset.class);
        String damThumbnailName = getName(width, height, additionalConf);
        Rendition rendition = asset.getRendition(damThumbnailName);
        rendition = (rendition == null) ?
                asset.getRendition("dam:thumbnail_" + width + ".png") : rendition;

        rendition = (rendition == null) ?
                UIHelper.getBestfitRendition(asset, width) : rendition;

        if (rendition == null) {
            return DEFAULT_ASSET_ICON;
        } else {
            return rendition.getPath();
        }
    }

    private String getName(int width, int height, Map<String, Object> additionalConf) {
        boolean doCenter = false;
        if (additionalConf.containsKey("doCenter")) {
            doCenter = (Boolean) additionalConf.get("doCenter");
        }
        final String[] selectors = (doCenter) ? new String[]{"margin"} : null;
        return DamUtil.getThumbnailName(width, height, selectors);
    }
}
