package com.day.cq.dam.commons.watermark;

import com.day.image.Layer;

/**
 *  A context in which the water marking operation takes place.<br/>
 *  Holds the image to be watermarked as a {@link Layer} object and the water mark details as {@link Watermark} object
 *
 *  @see TextWatermark
 *  @see ImageWatermark
 *
 */
public class WatermarkContext {

    private Layer image;

    private Watermark watermark;

    public WatermarkContext(Layer image, Watermark watermark) {
        this.image = image;
        this.watermark = watermark;
    }

    public Layer getImage() {
        return image;
    }

    public void setImage(Layer image) {
        this.image = image;
    }

    public Watermark getWatermark() {
        return watermark;
    }

    public void setWatermark(Watermark watermark) {
        this.watermark = watermark;
    }
}