/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.core;

import com.day.cq.commons.jcr.JcrConstants;
import static com.day.cq.commons.jcr.JcrConstants.JCR_CONTENT;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.DamConstants;
import static com.day.cq.dam.api.DamConstants.ORIGINAL_FILE;
import static com.day.cq.dam.api.DamConstants.SUBASSETS_FOLDER;
import com.day.cq.dam.commons.util.DamUtil;

import org.apache.felix.scr.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import java.io.InputStream;
import java.util.Calendar;

/**
 * The <code>AbstractSubAssetHandler</code> serves as basis for all other asset handler implementations and provides
 * common used functionality plus common used functionality for subasset extraction
 *
 * @deprecated Use {@link com.day.cq.dam.commons.handler.AbstractAssetHandler} instead
 */
//TODO: remove for CQ 5.5
@Component(componentAbstract = true, metatype=false)
public abstract class AbstractSubAssetHandler extends AbstractAssetHandler {

    public static final String TYPE_JCR_PATH = "JCR_PATH";

    /**
     * Logger instance for this class.
     */
    private static final Logger log = LoggerFactory.getLogger(AbstractSubAssetHandler.class);

    protected Node initializeSubAsset(String parentFilePath, String assetName,
                                      InputStream is, Session session,
                                      String mimeType, boolean doSave)
            throws RepositoryException {

        String parentAssetPath = DamUtil.binaryToAssetPath(parentFilePath);
        String subAssetPath = parentAssetPath + "/" + SUBASSETS_FOLDER + "/" + assetName;

        // create subassets node if not yet existing
        if (!session.itemExists(parentAssetPath + "/" + SUBASSETS_FOLDER)) {
            Node parent = (Node) session.getItem(parentAssetPath);
            parent.addNode(SUBASSETS_FOLDER, JcrConstants.NT_UNSTRUCTURED);
            if (doSave) {
                session.save();
            }
        }

        final Asset subAsset = getAssetManager(session).createAssetForBinary(subAssetPath, doSave);

        Node renditionFolder =
                getRenditionFolder(subAsset.getPath(), session);

        // save original file
        createFileNode(renditionFolder, is, mimeType, doSave);

        return subAsset.adaptTo(Node.class);
    }

    protected Node getRenditionFolder(String path, Session session) throws RepositoryException {
        Asset asset = getAssetManager(session).getAssetForBinary(path);
        return asset.adaptTo(Node.class).getNode(JCR_CONTENT + "/" + DamConstants.RENDITIONS_FOLDER);
    }

    protected Node createFileNode(Node parent, InputStream is, String mimeType,
                                  boolean doSave)
            throws RepositoryException {
        if (parent.hasNode(ORIGINAL_FILE)) {
            Node content = parent.getNode(ORIGINAL_FILE + "/" + JCR_CONTENT);
            setFileContent(content, is, mimeType);
            if (doSave) {
                content.getSession().save();
            }
        } else {
            Node file = parent.addNode(ORIGINAL_FILE, JcrConstants.NT_FILE);
            Node content = file.addNode(JCR_CONTENT, JcrConstants.NT_RESOURCE);
            setFileContent(content, is, mimeType);
            if (doSave) {
                parent.getSession().save();
            }
        }
        return parent.getNode(ORIGINAL_FILE);
    }

    protected void setFileContent(Node content, InputStream is, String mimeType) throws RepositoryException {
        content.setProperty(JcrConstants.JCR_MIMETYPE, mimeType);
        content.setProperty(JcrConstants.JCR_DATA, content.getSession().getValueFactory().createBinary(is));
        content.setProperty(JcrConstants.JCR_LASTMODIFIED, Calendar.getInstance());
    }

    protected boolean isSubasset(Node node) {
        try {
            return node.getPath().indexOf("/" + SUBASSETS_FOLDER + "/") > 0;
        } catch (RepositoryException e) {
            // TODO: what should we do here?....
            log.error("isSubAsset: error while determining sub-asset status for asset [{}]: ", safeGetPath(node), e);
            return false;
        }
    }
}
