/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.core;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

/**
 * A format handler knows how to handle a container-like file format and can be looked up in OSGI via an ID.
 *
 * @author dpfister
 * @deprecated Use {@link com.day.cq.dam.api.FormatHandler} instead.
 */
//todo: remove class for CQ 5.5
public interface FormatHandler {

    /**
     * Return a flag indicating whether the handler is able to handle the data.
     *
     * @param data data buffer
     * @param off  offset
     * @param len  number of valid bytes
     * @return <code>true</code> if the handler is able to handle the data; <code>false</code> otherwise
     */
    boolean accepts(byte[] data, int off, int len);

    /**
     * Process the input stream given.
     *
     * @param in      input stream
     * @param context call context
     * @throws IOException if an I/O error occurs
     */
    void process(InputStream in, Context context) throws IOException;

    /**
     * Return a thumbnail image from an input stream (utility method).
     *
     * @param in input stream
     * @return buffered image or <code>null</code>
     * @throws IOException        if an I/O error occurs
     * @throws ProcessorException if a processor reports an error
     */
    public BufferedImage getThumbnailImage(InputStream in)
            throws IOException, ProcessorException;

    /**
     * Return metadata as in input stream (utility method).
     *
     * @param in input stream
     * @return metadata input stream or <code>null</code>
     * @throws IOException        if an I/O error occurs
     * @throws ProcessorException if a processor reports an error
     */
    public InputStream getMetadata(InputStream in)
            throws IOException, ProcessorException;
}
