package com.day.cq.dam.core.process;

import static com.day.cq.dam.api.DamConstants.DAM_SIZE;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;


@Component(metatype = false)
@Service
@Property(name = "process.label", value = "Add dam size property")
public class AddPropertyWorkflowProcess  extends AbstractAssetWorkflowProcess{

    /**
     * Logger instance for this class.
     */
    private static final Logger log = LoggerFactory.getLogger(AddPropertyWorkflowProcess.class);
	private static final String JCR_CONTENT_JCR_DATA = "jcr:content/jcr:data";
	private static final String JCR_CONTENT_METADATA = "jcr:content/metadata";
	private static final int BATCH_SIZE = 500;
	public boolean addSize(Asset asset) throws  RepositoryException 
    {
		Rendition original = asset.getOriginal();
		Resource res = asset.adaptTo(Resource.class);
		Resource metadata = res.getChild(JCR_CONTENT_METADATA);
		Node metadataNode;
		if(metadata!= null)
			metadataNode = metadata.adaptTo(Node.class);
		else 
			return false;
		Node originalBinary = original.adaptTo(Node.class);
		
		if (originalBinary != null && metadataNode !=null && originalBinary.hasProperty(JCR_CONTENT_JCR_DATA)) {
			metadataNode.setProperty(DAM_SIZE, ""+originalBinary.getProperty(JCR_CONTENT_JCR_DATA).getBinary().getSize(), PropertyType.LONG);//setProperty(DAM_SIZE, ,PropertyType.LONG);
			return true;
		}
    	return false;
    }
    private Resource getPayloadResource(final WorkItem item, final Session session) {
    	Resource resource = null;
        if (item.getWorkflowData().getPayloadType().equals(TYPE_JCR_PATH)) {
            final String path = item.getWorkflowData().getPayload().toString();
            resource = getResourceResolver(session).getResource(path);
        }
        return resource;
    }
    

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData)
            throws WorkflowException {
    	try {
    		final Session session = workflowSession.getSession();
            Resource resource = getPayloadResource(workItem, session) ;
            if (null != resource) {
            	if(DamUtil.isAsset(resource))
            	{
            		Asset asset = DamUtil.resolveToAsset(resource);
                    addSize(asset);
                    return;
            	}
            	else
            	{
            		Iterator<Asset> assetList = DamUtil.getAssets(resource);
            		int count = 0;
            		while (assetList.hasNext())
            		{
            			Asset asset = assetList.next();
            			addSize(asset);
            			count++;
            			if(count >= BATCH_SIZE )
            			{
            				count = 0;
            				session.save();
            			}
            			
            		}
            	}
            } else {
                log.error("Content root could not be resolved");
            }

    	}
    	catch (Exception e) {
            log.warn(
                "unexpected error occurred during adding Property. Cause: {}",
                e.getMessage(), e);
        }
    	return;
    }
}
