/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.core.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.jcr.*;

import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.core.impl.PrivateConstants;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.JcrConstants;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.DamConstants;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;

import static com.day.cq.commons.jcr.JcrConstants.JCR_CONTENT;
import static com.day.cq.dam.api.DamConstants.METADATA_FOLDER;

/**
 * The <code>ApplyProcessingProfileProcess</code> is called in a workflow
 * process step. This process will apply processing profile to the asset, if the
 * payload of the step is an {@link com.day.cq.dam.api.Asset Asset} or a part of
 * an {@link com.day.cq.dam.api.Asset Asset}.
 *
 * @see AbstractAssetWorkflowProcess
 */
@SuppressWarnings("unused")
@Component(metatype = false)
@Service
@Property(name = "process.label", value = "Apply Metadata Processing Profile")
@Deprecated
public class ApplyProcessingProfileProcess extends AbstractAssetWorkflowProcess {

    /**
     * Logger instance for this class.
     */
    private static final Logger log = LoggerFactory.getLogger(ApplyProcessingProfileProcess.class);

    private static final String JCR_CONTENT_METADATA = JcrConstants.JCR_CONTENT + "/" + DamConstants.METADATA_FOLDER;
    
    private ProcessingProfileApplier profileApplier = new ProcessingProfileApplier();

    public void execute(WorkItem workItem, WorkflowSession workflowSession,
                        MetaDataMap args) throws WorkflowException {
        try {
            final Session session = workflowSession.getSession();
            final Asset asset = getAssetFromPayload(workItem, session);
            profileApplier.applyProcessingProfile(session, asset);
            session.save();
        } catch (RepositoryException e) {
            log.warn("unexpected error occurred during metadata extraction. Cause: {}", e.getMessage(), e);
        }
    }
}
